/*
 * Decompiled with CFR 0.152.
 */
package net.ribs.vintagedelight.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class FermentingRecipe
implements Recipe<SimpleContainer> {
    private static final int FIRST_INPUT_SLOT = 0;
    private static final int LAST_INPUT_SLOT = 5;
    private static final int CONTAINER_SLOT = 6;
    private final NonNullList<Ingredient> inputItems;
    private final Ingredient containerIngredient;
    private final ItemStack output;
    private final ItemStack secondaryOutput;
    private final int processingTime;
    private final ResourceLocation id;
    private static final int defaultProcessingTime = 100;

    public FermentingRecipe(NonNullList<Ingredient> inputItems, Ingredient containerIngredient, ItemStack output, ItemStack secondaryOutput, int processingTime, ResourceLocation id) {
        this.inputItems = inputItems;
        this.containerIngredient = containerIngredient;
        this.output = output;
        this.secondaryOutput = secondaryOutput;
        this.processingTime = processingTime;
        this.id = id;
    }

    public boolean matches(SimpleContainer pContainer, Level pLevel) {
        ItemStack containerItem;
        if (pLevel.m_5776_()) {
            return false;
        }
        NonNullList requiredIngredients = NonNullList.m_122779_();
        requiredIngredients.addAll(this.inputItems);
        for (int i = 0; i <= 5; ++i) {
            ItemStack itemInSlot = pContainer.m_8020_(i);
            if (itemInSlot.m_41619_()) continue;
            boolean matched = false;
            for (Ingredient ingredient : requiredIngredients) {
                if (!ingredient.test(itemInSlot)) continue;
                requiredIngredients.remove((Object)ingredient);
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        if (!this.containerIngredient.m_43947_() && !this.containerIngredient.test(containerItem = pContainer.m_8020_(6))) {
            return false;
        }
        return requiredIngredients.isEmpty();
    }

    public ItemStack getSecondaryResultItem() {
        return this.secondaryOutput != null ? this.secondaryOutput.m_41777_() : ItemStack.f_41583_;
    }

    public int getProcessingTime() {
        return this.processingTime;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputItems;
    }

    public ItemStack assemble(SimpleContainer pContainer, RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public ItemStack getContainerItemStack() {
        return this.containerIngredient.m_43908_().length > 0 ? this.containerIngredient.m_43908_()[0] : ItemStack.f_41583_;
    }

    public static class Serializer
    implements RecipeSerializer<FermentingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("vintagedelight", "fermenting");

        public FermentingRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            ItemStack output = this.readItemStackWithNBT(GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"output"));
            ItemStack secondaryOutput = ItemStack.f_41583_;
            if (pSerializedRecipe.has("secondaryOutput")) {
                secondaryOutput = this.readItemStackWithNBT(GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"secondaryOutput"));
            }
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)pSerializedRecipe, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122780_((int)ingredients.size(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredients.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            Ingredient containerIngredient = Ingredient.f_43901_;
            if (pSerializedRecipe.has("container")) {
                containerIngredient = Ingredient.m_43917_((JsonElement)pSerializedRecipe.get("container"));
            }
            int processingTime = GsonHelper.m_13824_((JsonObject)pSerializedRecipe, (String)"processingTime", (int)100);
            return new FermentingRecipe((NonNullList<Ingredient>)inputs, containerIngredient, output, secondaryOutput, processingTime, pRecipeId);
        }

        private ItemStack readItemStackWithNBT(JsonObject jsonObject) {
            String itemName = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"item");
            int count = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"count", (int)1);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
            if (item == null) {
                throw new JsonSyntaxException("Unknown item '" + itemName + "'");
            }
            ItemStack stack = new ItemStack((ItemLike)item, count);
            if (jsonObject.has("nbt")) {
                try {
                    String nbtData = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"nbt");
                    CompoundTag nbt = TagParser.m_129359_((String)nbtData);
                    stack.m_41751_(nbt);
                }
                catch (CommandSyntaxException e) {
                    throw new JsonSyntaxException("Invalid NBT data in 'nbt' tag", (Throwable)e);
                }
            }
            return stack;
        }

        public void toNetwork(FriendlyByteBuf pBuffer, FermentingRecipe pRecipe) {
            pBuffer.writeInt(pRecipe.inputItems.size());
            for (Ingredient ingredient : pRecipe.m_7527_()) {
                ingredient.m_43923_(pBuffer);
            }
            pBuffer.writeItemStack(pRecipe.m_8043_(null), false);
            boolean hasSecondaryOutput = !pRecipe.getSecondaryResultItem().m_41619_();
            pBuffer.writeBoolean(hasSecondaryOutput);
            if (hasSecondaryOutput) {
                pBuffer.writeItemStack(pRecipe.getSecondaryResultItem(), false);
            }
            pBuffer.writeInt(pRecipe.getProcessingTime());
            pRecipe.containerIngredient.m_43923_(pBuffer);
        }

        public FermentingRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            int inputCount = pBuffer.readInt();
            NonNullList inputs = NonNullList.m_122780_((int)inputCount, (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputCount; ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
            }
            ItemStack output = pBuffer.m_130267_();
            ItemStack secondaryOutput = ItemStack.f_41583_;
            boolean hasSecondaryOutput = pBuffer.readBoolean();
            if (hasSecondaryOutput) {
                secondaryOutput = pBuffer.m_130267_();
            }
            int processingTime = pBuffer.readInt();
            Ingredient containerIngredient = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            return new FermentingRecipe((NonNullList<Ingredient>)inputs, containerIngredient, output, secondaryOutput, processingTime, pRecipeId);
        }
    }

    public static class Type
    implements RecipeType<FermentingRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "fermenting";
    }
}

